/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import magiclantern.CommonCode;
import magiclantern.EditBase;
import magiclantern.EditBrowsePanelCoreRoutines;
import magiclantern.EditCellDatum;
import magiclantern.MagicLantern;
import magiclantern.MyMessageDialog;

public final class EditShowPanel
extends EditBrowsePanelCoreRoutines {
    private JButton FindDuplicatesButton;
    private JButton RedoButton;
    private JButton SaveButton;
    private JTextField SlideDurationTextField;
    private JButton UndoButton;
    private JComboBox columnsComboBox;
    private JButton copyButton;
    protected JMenuItem copyMenuItem;
    private JButton cutButton;
    protected JMenuItem cutMenuItem;
    protected JPopupMenu editPopupMenu;
    private JScrollPane editShowScrollPane;
    private JToolBar editToolBar;
    private JList editorList;
    private JMenuItem infoMenuItem;
    private JPanel innerPanel;
    private JLabel jLabel2;
    private JButton newFileButton;
    private JButton pasteButton;
    protected JMenuItem pasteMenuItem;
    private JMenuItem removeSoundMenuItem;
    private JComboBox showComboBox;
    private JMenuItem soundMenuItem;
    private JLabel statusLabel;
    private JPanel topPanel;

    public EditShowPanel(MagicLantern magicLantern, EditBase editBase) {
        super(magicLantern, editBase);
        this.initComponents();
        this.initialize(this.editorList, this.editPopupMenu, this.SaveButton);
        this.editShowScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.populateFileComboBox();
        this.setupColumnsComboBox();
        this.SlideDurationTextField.setText("" + this.parent.sv_editSlideDurationSeconds);
        this.readShowFile();
        this.setupTooltips(true);
        this.updateCutCopyPasteButtons();
    }

    void setupColumnsComboBox() {
        this.columnsComboBox.removeAllItems();
        for (int i2 = 1; i2 < 8; ++i2) {
            this.columnsComboBox.addItem(i2);
        }
        this.columnsComboBox.setSelectedIndex(this.parent.editColumns - 1);
    }

    void populateFileComboBox() {
        this.parent.buildShowList(this.showComboBox, this.parent.dataPath);
        if (this.parent.sv_editSelectedShow.length() > 0) {
            this.showComboBox.setSelectedItem(this.parent.sv_editSelectedShow);
        } else {
            this.showComboBox.setSelectedIndex(0);
        }
    }

    void setEditColumns(ActionEvent actionEvent) {
        if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
            this.parent.editColumns = this.columnsComboBox.getSelectedIndex() + 1;
            this.reformatDisplay();
            this.base.browsePanel.reformatDisplay();
        }
    }

    @Override
    void updateButtons() {
        this.UndoButton.setEnabled(this.undoStack.size() > 0);
        this.RedoButton.setEnabled(this.redoStack.size() > 0);
        this.SaveButton.setEnabled(this.contentChanged);
    }

    void updateCutCopyPasteButtons() {
        super.updateCutCopyPasteButtons(this.cutMenuItem, this.copyMenuItem, this.pasteMenuItem, this.cutButton, this.copyButton, this.pasteButton);
        EditCellDatum editCellDatum = (EditCellDatum)this.editList.getSelectedValue();
        this.removeSoundMenuItem.setEnabled(editCellDatum != null && editCellDatum.getSoundPath() != null);
    }

    void comboActionPerformed(ActionEvent actionEvent) {
        if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
            this.readShowFile();
        }
    }

    void readShowFile() {
        if (this.contentChanged && !this.saveFileOnExit()) {
            return;
        }
        this.editListModel.removeAllElements();
        String string = (String)this.showComboBox.getSelectedItem();
        if (string != null) {
            if (string.equals(this.parent.disabledTitle)) {
                this.activeFile = null;
            } else {
                this.activeFile = this.parent.dataPath + this.parent.fileSep + string + ".txt";
                String string2 = CommonCode.readTextFile(this.activeFile, this.parent.lineSep);
                if (string2 != null) {
                    String[] stringArray = string2.split(this.parent.lineSep);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        String string3 = CommonCode.strip(stringArray[i2]);
                        this.addListItem(string3);
                    }
                }
            }
            this.parent.sv_editSelectedShow = string;
        }
        this.reformatDisplay();
        this.setContentChanged(false);
        this.parent.setStatus("Read " + this.editListModel.size() + " slides", false, 1);
    }

    boolean saveShowFile() {
        boolean bl = false;
        if (this.contentChanged && this.activeFile != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.editListModel.size(); ++i2) {
                EditCellDatum editCellDatum = (EditCellDatum)this.editListModel.get(i2);
                stringBuffer.append(editCellDatum.getFileSoundCombinationPath() + this.parent.lineSep);
            }
            bl = CommonCode.saveTextFile(this.parent, stringBuffer.toString(), this.activeFile, false);
            if (bl) {
                this.setContentChanged(false);
                this.parent.readShowFile(true);
            }
        }
        return bl;
    }

    boolean saveFileOnExit() {
        boolean bl = false;
        if (this.contentChanged && this.activeFile != null) {
            File file = new File(this.activeFile);
            int n2 = JOptionPane.showConfirmDialog(this.parent, "File \"" + file.getName() + "\" has been changed. Want to save it?", "Save Changed File", 1);
            boolean bl2 = bl = n2 == 0;
            if (bl) {
                bl = this.saveShowFile();
            } else if (n2 == 1) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.contentChanged = false;
        }
        return bl;
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getModifiers();
        if ((n3 & 2) != 0) {
            if (n2 == 88) {
                this.cutAction();
            } else if (n2 == 67) {
                this.copyAction();
            } else if (n2 == 86) {
                this.pasteAction();
            } else if (n2 == 90) {
                this.undo();
            } else if ((n3 & 1) != 0 && n2 == 90) {
                this.redo();
            }
        }
    }

    String ldgzro(int n2) {
        String string = "" + n2;
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    @Override
    void updateShowDisplay() {
        int n2 = this.editListModel.size();
        int n3 = this.parent.sv_editSlideDurationSeconds * n2;
        int n4 = n3 % 60;
        int n5 = (n3 /= 60) % 60;
        int n6 = n3 /= 60;
        String string = "" + n2 + " | " + this.ldgzro(n6) + ":" + this.ldgzro(n5) + ":" + this.ldgzro(n4);
        this.statusLabel.setText(string);
    }

    void setDurationIfEnter(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            try {
                int n2 = Integer.parseInt(this.SlideDurationTextField.getText());
                if (n2 > 0) {
                    this.parent.sv_editSlideDurationSeconds = n2;
                    this.updateShowDisplay();
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.SlideDurationTextField.setText("" + this.parent.sv_editSlideDurationSeconds);
            }
        }
    }

    void createNewShow() {
        String string = JOptionPane.showInputDialog(this, "Please enter a name for the new show", "Create New Show", 3);
        if ((string = CommonCode.strip(string)).length() > 0) {
            String string2 = this.parent.dataPath + this.parent.fileSep + string + ".txt";
            File file = new File(string2);
            if (file.exists()) {
                JOptionPane.showMessageDialog(this, "There is already a show with the name \"" + string + "\". Please choose another name.", "Duplicate Show", 2);
            } else {
                CommonCode.saveTextFile(this.parent, "", string2, false);
                this.parent.sv_editSelectedShow = string;
                this.populateFileComboBox();
                this.readShowFile();
                this.parent.updateShowList();
            }
        }
    }

    void searchForDuplicates() {
        String string;
        Serializable serializable;
        Vector<String> vector = new Vector<String>();
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.editListModel.getSize(); ++i2) {
            serializable = (EditCellDatum)this.editListModel.get(i2);
            string = ((EditCellDatum)serializable).getPath();
            vector.add(string);
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new Vector());
            }
            ((Vector)hashMap.get(string)).add(i2 + 1);
        }
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        serializable = new StringBuffer();
        string = "";
        for (String string2 : vector) {
            if (hashMap2.containsKey(string2)) continue;
            hashMap2.put(string2, true);
            Vector vector2 = (Vector)hashMap.get(string2);
            if (vector2.size() <= 1) continue;
            if (string.length() == 0) {
                ((StringBuffer)serializable).append("The following duplicates were found:" + this.parent.lineSep + this.parent.lineSep);
            }
            string = "Path " + string2 + ", locations: ";
            Iterator iterator = vector2.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (!bl) {
                    string = string + ",";
                }
                string = string + iterator.next();
                bl = false;
            }
            ((StringBuffer)serializable).append(string + this.parent.lineSep);
        }
        if (((StringBuffer)serializable).length() > 0) {
            ((StringBuffer)serializable).append(this.parent.lineSep + "This dialog may be kept open while editing.");
            new MyMessageDialog(this.parent, false, this.parent.programName + ": Duplicate Slides Found", ((StringBuffer)serializable).toString(), this.parent.getIconImage());
        } else {
            new MyMessageDialog(this.parent, false, this.parent.programName + ": No Duplicates", "No duplicate slides were found.", this.parent.getIconImage());
        }
    }

    String chooseSoundFile(String string) {
        String string2 = null;
        JFileChooser jFileChooser = new JFileChooser();
        boolean bl = CommonCode.changeLookAndFeel(jFileChooser);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(this.parent.programName + ": Choose Sound File");
        jFileChooser.setApproveButtonText("Accept");
        jFileChooser.setCurrentDirectory(new File(this.parent.sv_soundSourceDirectory));
        if (string != null) {
            jFileChooser.setSelectedFile(new File(string));
        }
        int n2 = jFileChooser.showOpenDialog(this.parent);
        if (bl) {
            CommonCode.restoreSystemLookAndFeel();
        }
        if (n2 == 0) {
            try {
                this.parent.sv_soundSourceDirectory = jFileChooser.getSelectedFile().getCanonicalPath();
                string2 = jFileChooser.getSelectedFile().toString();
                System.out.println(this.parent.sv_soundSourceDirectory);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        return string2;
    }

    void addSound() {
        String string;
        EditCellDatum editCellDatum = (EditCellDatum)this.editList.getSelectedValue();
        if (editCellDatum != null && (string = this.chooseSoundFile(editCellDatum.getSoundPath())) != null) {
            editCellDatum.setSoundPath(string);
            this.setContentChanged(true);
            this.updateCutCopyPasteButtons();
        }
    }

    void removeSound() {
        EditCellDatum editCellDatum = (EditCellDatum)this.editList.getSelectedValue();
        if (editCellDatum != null && editCellDatum.getSoundPath() != null) {
            editCellDatum.setSoundPath(null);
            this.setContentChanged(true);
            this.updateCutCopyPasteButtons();
        }
    }

    private void initComponents() {
        this.editPopupMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.soundMenuItem = new JMenuItem();
        this.removeSoundMenuItem = new JMenuItem();
        this.innerPanel = new JPanel();
        this.topPanel = new JPanel();
        this.showComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.SlideDurationTextField = new JTextField();
        this.columnsComboBox = new JComboBox();
        this.editShowScrollPane = new JScrollPane();
        this.editorList = new JList();
        this.editToolBar = new JToolBar();
        this.newFileButton = new JButton();
        this.SaveButton = new JButton();
        this.FindDuplicatesButton = new JButton();
        this.UndoButton = new JButton();
        this.RedoButton = new JButton();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.statusLabel = new JLabel();
        this.infoMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/dialog-question.png")));
        this.infoMenuItem.setText("Info");
        this.infoMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditShowPanel.this.infoMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.infoMenuItem);
        this.cutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-cut.png")));
        this.cutMenuItem.setMnemonic('t');
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditShowPanel.this.cutMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.cutMenuItem);
        this.copyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-copy.png")));
        this.copyMenuItem.setMnemonic('y');
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditShowPanel.this.copyMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-paste.png")));
        this.pasteMenuItem.setMnemonic('p');
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditShowPanel.this.pasteMenuItemMousePressed(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.pasteMenuItem);
        this.soundMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/applications-multimedia.png")));
        this.soundMenuItem.setText("Add Sound");
        this.soundMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EditShowPanel.this.soundMenuItemMouseReleased(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.soundMenuItem);
        this.removeSoundMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-clear.png")));
        this.removeSoundMenuItem.setText("Remove Sound");
        this.removeSoundMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EditShowPanel.this.removeSoundMenuItemMouseReleased(mouseEvent);
            }
        });
        this.editPopupMenu.add(this.removeSoundMenuItem);
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.showComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.showComboBox.setToolTipText("Select a slide show or click the new show button on the toolbar");
        this.showComboBox.setFocusable(false);
        this.showComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditShowPanel.this.showComboBoxActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this.showComboBox);
        this.jLabel2.setText("Time:");
        this.topPanel.add(this.jLabel2);
        this.SlideDurationTextField.setHorizontalAlignment(4);
        this.SlideDurationTextField.setText("22");
        this.SlideDurationTextField.setToolTipText("Enter the expected slide duration");
        this.SlideDurationTextField.setMinimumSize(new Dimension(40, 27));
        this.SlideDurationTextField.setPreferredSize(new Dimension(40, 27));
        this.SlideDurationTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                EditShowPanel.this.SlideDurationTextFieldKeyTyped(keyEvent);
            }
        });
        this.topPanel.add(this.SlideDurationTextField);
        this.columnsComboBox.setToolTipText("Choose display columns");
        this.columnsComboBox.setFocusable(false);
        this.columnsComboBox.setMinimumSize(new Dimension(60, 19));
        this.columnsComboBox.setPreferredSize(new Dimension(60, 19));
        this.columnsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditShowPanel.this.columnsComboBoxActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this.columnsComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.innerPanel.add((Component)this.topPanel, gridBagConstraints);
        this.editShowScrollPane.setFocusable(false);
        this.editorList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n2) {
                return this.strings[n2];
            }
        });
        this.editorList.setSelectionMode(1);
        this.editorList.setLayoutOrientation(2);
        this.editorList.setVisibleRowCount(200);
        this.editorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditShowPanel.this.editorListValueChanged(listSelectionEvent);
            }
        });
        this.editorList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                EditShowPanel.this.editorListKeyPressed(keyEvent);
            }
        });
        this.editShowScrollPane.setViewportView(this.editorList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.innerPanel.add((Component)this.editShowScrollPane, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
        this.editToolBar.setRollover(true);
        this.editToolBar.setFocusable(false);
        this.newFileButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/document-new.png")));
        this.newFileButton.setToolTipText("Create a new show");
        this.newFileButton.setFocusable(false);
        this.newFileButton.setHorizontalTextPosition(0);
        this.newFileButton.setVerticalTextPosition(3);
        this.newFileButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.newFileButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.newFileButton);
        this.SaveButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/document-save.png")));
        this.SaveButton.setToolTipText("Save changed show");
        this.SaveButton.setFocusable(false);
        this.SaveButton.setHorizontalTextPosition(0);
        this.SaveButton.setVerticalTextPosition(3);
        this.SaveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.SaveButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.SaveButton);
        this.FindDuplicatesButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/system-run.png")));
        this.FindDuplicatesButton.setToolTipText("Search for duplicate slides");
        this.FindDuplicatesButton.setFocusable(false);
        this.FindDuplicatesButton.setHorizontalTextPosition(0);
        this.FindDuplicatesButton.setVerticalTextPosition(3);
        this.FindDuplicatesButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.FindDuplicatesButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.FindDuplicatesButton);
        this.UndoButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-undo.png")));
        this.UndoButton.setToolTipText("Undo last action (Ctrl+Z)");
        this.UndoButton.setEnabled(false);
        this.UndoButton.setFocusable(false);
        this.UndoButton.setHorizontalTextPosition(0);
        this.UndoButton.setVerticalTextPosition(3);
        this.UndoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.UndoButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.UndoButton);
        this.RedoButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-redo.png")));
        this.RedoButton.setToolTipText("Redo last action (Ctrl+Shift+Z)");
        this.RedoButton.setEnabled(false);
        this.RedoButton.setFocusable(false);
        this.RedoButton.setHorizontalTextPosition(0);
        this.RedoButton.setVerticalTextPosition(3);
        this.RedoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.RedoButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.RedoButton);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-cut.png")));
        this.cutButton.setToolTipText("Cut (Ctrl+X)");
        this.cutButton.setFocusable(false);
        this.cutButton.setHorizontalTextPosition(0);
        this.cutButton.setVerticalTextPosition(3);
        this.cutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.cutButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.cutButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-copy.png")));
        this.copyButton.setToolTipText("Copy (Ctrl+C)");
        this.copyButton.setFocusable(false);
        this.copyButton.setHorizontalTextPosition(0);
        this.copyButton.setVerticalTextPosition(3);
        this.copyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.copyButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.copyButton);
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/edit-paste.png")));
        this.pasteButton.setToolTipText("Paste (Ctrl+V)");
        this.pasteButton.setFocusable(false);
        this.pasteButton.setHorizontalTextPosition(0);
        this.pasteButton.setVerticalTextPosition(3);
        this.pasteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditShowPanel.this.pasteButtonMouseClicked(mouseEvent);
            }
        });
        this.editToolBar.add(this.pasteButton);
        this.statusLabel.setToolTipText("<html>This shows the slide count and a show time estimate<br/>based on the slide duration entered below</html>");
        this.editToolBar.add(this.statusLabel);
        this.add((Component)this.editToolBar, "North");
    }

    private void cutMenuItemMousePressed(MouseEvent mouseEvent) {
        this.cutAction();
    }

    private void copyMenuItemMousePressed(MouseEvent mouseEvent) {
        this.copyAction();
    }

    private void pasteMenuItemMousePressed(MouseEvent mouseEvent) {
        this.pasteAction();
    }

    private void UndoButtonMouseClicked(MouseEvent mouseEvent) {
        this.undo();
    }

    private void RedoButtonMouseClicked(MouseEvent mouseEvent) {
        this.redo();
    }

    private void SaveButtonMouseClicked(MouseEvent mouseEvent) {
        this.saveShowFile();
    }

    private void editorListKeyPressed(KeyEvent keyEvent) {
        this.handleKeyPressed(keyEvent);
    }

    private void cutButtonMouseClicked(MouseEvent mouseEvent) {
        this.cutAction();
    }

    private void copyButtonMouseClicked(MouseEvent mouseEvent) {
        this.copyAction();
    }

    private void pasteButtonMouseClicked(MouseEvent mouseEvent) {
        this.pasteAction();
    }

    private void newFileButtonMouseClicked(MouseEvent mouseEvent) {
        this.createNewShow();
    }

    private void FindDuplicatesButtonMouseClicked(MouseEvent mouseEvent) {
        this.searchForDuplicates();
    }

    private void infoMenuItemMousePressed(MouseEvent mouseEvent) {
        this.showImageInfo();
    }

    private void SlideDurationTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setDurationIfEnter(keyEvent);
    }

    private void showComboBoxActionPerformed(ActionEvent actionEvent) {
        this.comboActionPerformed(actionEvent);
    }

    private void columnsComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setEditColumns(actionEvent);
    }

    private void editorListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateCutCopyPasteButtons();
    }

    private void soundMenuItemMouseReleased(MouseEvent mouseEvent) {
        this.addSound();
    }

    private void removeSoundMenuItemMouseReleased(MouseEvent mouseEvent) {
        this.removeSound();
    }
}

