/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.Timer;
import magiclantern.MagicLantern;
import magiclantern.ShowDataItem;

public final class ImagePanel
extends JPanel {
    MagicLantern parent;
    String id;
    String currentImagePath = "";
    BufferedImage image = null;
    BufferedImage scaledImage = null;
    BufferedImage oldScaledImage = null;
    int width = -1;
    int height = -1;
    int offsetw;
    int offseth;
    int oldOffsetw;
    int oldOffseth;
    boolean testPattern = false;
    boolean testPatternOK = false;
    float alpha;
    float lastAlpha;
    int fadeSteps = -1;
    int fadeDuration = -1;
    ArrayList<Float> alphaValues;
    boolean fadeMode;
    boolean threadRunning = false;
    Timer timer;
    int counter;

    public ImagePanel(MagicLantern magicLantern, String string) {
        this.id = string;
        this.parent = magicLantern;
        this.initComponents();
        this.setOpaque(false);
    }

    public void newImage(int n2, ShowDataItem showDataItem, boolean bl) {
        this.fadeMode = this.parent.sv_fadeMode;
        String string = showDataItem.getFilePath();
        if (string == null || string.length() == 0) {
            this.image = null;
        } else if (!string.equals(this.currentImagePath) || bl) {
            try {
                this.image = this.parent.readImage(string);
                this.width = -1;
                this.height = -1;
                this.parent.performSoundEffect(showDataItem);
                this.oldScaledImage = this.scaledImage;
                this.oldOffsetw = this.offsetw;
                this.oldOffseth = this.offseth;
            }
            catch (Exception exception) {
                System.out.println("newImage(): " + exception + " : " + string);
            }
        }
        if (!string.equals(this.currentImagePath) && this.fadeMode) {
            if (this.fadeSteps != this.parent.sv_fadeSteps || this.fadeDuration != this.parent.sv_fadeDurationMilliseconds) {
                this.fadeSteps = this.parent.sv_fadeSteps;
                this.fadeDuration = this.parent.sv_fadeDurationMilliseconds;
                this.alphaValues = new ArrayList();
                for (int i2 = 0; i2 <= this.fadeSteps; ++i2) {
                    float f2 = (float)Math.pow((double)i2 / (double)this.fadeSteps, 0.333);
                    this.alphaValues.add(Float.valueOf(f2));
                }
                this.lastAlpha = this.alphaValues.get(this.alphaValues.size() - 1).floatValue();
            }
            if (!this.threadRunning) {
                this.threadRunning = true;
                this.counter = 0;
                int n3 = this.fadeDuration / this.fadeSteps;
                Iterator<Float> iterator = this.alphaValues.iterator();
                this.timer = new Timer(n3, actionEvent -> {
                    if (!iterator.hasNext()) {
                        this.timer.stop();
                        this.threadRunning = false;
                    } else {
                        this.alpha = ((Float)iterator.next()).floatValue();
                        this.testPatternOK = this.alpha == this.lastAlpha;
                        this.repaint();
                        Toolkit.getDefaultToolkit().sync();
                    }
                });
                this.timer.start();
            }
        } else {
            this.testPatternOK = true;
            this.repaint();
        }
        this.currentImagePath = string;
    }

    public void clearImage() {
        this.image = null;
        this.currentImagePath = "";
    }

    public void toggleTestPattern() {
        this.testPattern = !this.testPattern;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.image != null && (n2 != this.width || n3 != this.height)) {
            double d2;
            this.width = n2;
            this.height = n3;
            int n4 = this.image.getWidth(this);
            int n5 = this.image.getHeight(this);
            double d3 = (double)n3 / (double)n5;
            double d4 = d3 < (d2 = (double)n2 / (double)n4) ? d3 : d2;
            int n6 = (int)(d4 * (double)n4);
            int n7 = (int)(d4 * (double)n5);
            this.offsetw = n6 > n2 ? 0 : (n2 - n6) / 2;
            this.offseth = n7 > n3 ? 0 : (n3 - n7) / 2;
            int n8 = this.parent.sv_fadeMode || this.image.getTransparency() != 1 ? 2 : 1;
            this.scaledImage = new BufferedImage(this.width, this.height, n8);
            Graphics2D graphics2D2 = this.scaledImage.createGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D2.setColor(Color.black);
            graphics2D2.fillRect(0, 0, this.width, this.height);
            graphics2D2.drawImage(this.image, this.offsetw, this.offseth, n6, n7, this);
            graphics2D2.dispose();
        }
        if (this.image != null && !this.parent.blankScreen) {
            if (this.scaledImage != null) {
                if (this.threadRunning && this.fadeMode && this.oldScaledImage != null) {
                    graphics2D.drawImage((Image)this.oldScaledImage, 0, 0, this);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    graphics2D.drawImage((Image)this.scaledImage, 0, 0, this);
                } else {
                    graphics.drawImage(this.scaledImage, 0, 0, this);
                }
            }
            if (this.testPattern && this.testPatternOK) {
                graphics2D.setColor(Color.yellow);
                graphics2D.drawLine(0, 0, 0, n3 - 1);
                graphics2D.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
                graphics2D.drawLine(n2 - 1, n3 - 1, n2 - 1, 0);
                graphics2D.drawLine(n2 - 1, 0, 0, 0);
            }
        }
        graphics2D.dispose();
    }

    private void initComponents() {
        this.setBackground(Color.black);
        this.setBorder(null);
        this.setDoubleBuffered(false);
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ImagePanel.this.formMouseClicked(mouseEvent);
            }
        });
        this.setLayout(new GridBagLayout());
    }

    private void formMouseClicked(MouseEvent mouseEvent) {
        this.parent.handleMouseClick(mouseEvent);
    }
}

