/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import magiclantern.CommonCode;
import magiclantern.EditBase;
import magiclantern.EditCellDatum;
import magiclantern.FullScreenFrame;
import magiclantern.ImagePanel;
import magiclantern.InitManager;
import magiclantern.MP3Play;
import magiclantern.MyDefaultListModel;
import magiclantern.MyFileNameFilter;
import magiclantern.MyHelpPane;
import magiclantern.ScaledImageGenerator;
import magiclantern.SetupControlPanel;
import magiclantern.ShowDataItem;
import magiclantern.ShowList;
import magiclantern.StringComparatorNoCase;

public final class MagicLantern
extends JFrame {
    final String appVersion = "2.2";
    String appPath;
    String fileSep;
    String lineSep;
    String escapedFileSep;
    String configPath;
    String userDir;
    String userPath;
    String dataPath;
    String defaultFilenameFilter = "(?i).*\\.(png|jpe?g)$";
    String browseContentPath;
    final String appName;
    final String programName;
    Thread outOfMemoryThread;
    Date outOfMemoryFlag = null;
    MyHelpPane helpPane;
    FullScreenFrame fullFrame = null;
    ImagePanel smallImage;
    EditBase editBase;
    ScaledImageGenerator thumbnailGenerator;
    SetupControlPanel setupControlPanel;
    ShowList[] showList;
    int editColumns = 4;
    String thumbnailDir = "MagicLanternThumbnails";
    String scaledImageDir = "MagicLanternScaledImages";
    String disabledTitle = "-- Select Show --";
    boolean fullFrameMode = false;
    boolean blankScreen = false;
    boolean lastAutoSlideFlag = false;
    boolean editPreview = false;
    int priorTab = -1;
    InitManager initManager;
    String[] autoShowDurations = new String[]{"2", "5", "10", "15", "20", "25", "30"};
    MP3Play mp3Player;
    protected JFrame sv_mainframe;
    protected boolean sv_thumbnailMode = true;
    protected int sv_thumbnailImageSize = 120;
    protected int sv_scaledImageSize = 1280;
    protected int sv_scaleQualityIndex = 0;
    protected int sv_currentTab = 3;
    protected int sv_screenState = 0;
    protected int sv_showIndex = 0;
    protected int sv_showListIndex = 0;
    protected int sv_show0Index = 0;
    protected int sv_show1Index = 0;
    protected int sv_dividerLocation = 400;
    protected int sv_editColumns = 3;
    protected boolean sv_editWhiteBackground = false;
    protected int sv_editSlideDurationSeconds = 22;
    protected int sv_autoShowSlideDurationSeconds = 15;
    protected boolean sv_autoRepeat = false;
    protected boolean sv_autoShow = false;
    protected boolean sv_fadeMode = false;
    protected int sv_fadeDurationMilliseconds = 500;
    protected int sv_fadeSteps = 20;
    protected String sv_editSearchDirectory = "";
    protected String sv_editSelectedShow = "";
    protected String sv_scaledImageGeneratorDirectory = "";
    protected String sv_soundSourceDirectory = "";
    protected Rectangle screenBounds = new Rectangle(0, 0, 800, 600);
    private JToggleButton AutoShowButton;
    private JPanel ImagePanel;
    private JPanel ImageTab;
    private JComboBox ShowListComboBox;
    private JPanel StatusPanel;
    private JPanel TopPanel;
    private JCheckBox autoRepeatCheckBox;
    private JButton blankButton;
    private JPanel editTab;
    private JPanel helpTab;
    private JButton nextButton;
    private JButton priorButton;
    private JButton quitButton;
    private JPanel setupPanel;
    private JLabel statusLabel;
    private JButton swapButton;
    private JTabbedPane tabbedPane;
    private JButton toBeginButton;
    private JButton toEndButton;

    public MagicLantern() {
        this.initComponents();
        this.mp3Player = new MP3Play();
        this.sv_mainframe = this;
        this.setBounds(this.screenBounds);
        this.appName = this.getClass().getSimpleName();
        URL uRL = this.getClass().getResource(this.appName + ".class");
        this.appPath = uRL.getPath().replaceFirst("(.*?)!.*", "$1");
        this.appPath = this.appPath.replaceFirst("file:", "");
        this.appPath = new File(this.appPath).getPath();
        this.programName = this.appName + " " + "2.2";
        this.setTitle(this.programName);
        this.setIconImage(new ImageIcon(this.getClass().getResource("icons/" + this.appName + ".png")).getImage());
        this.userDir = System.getProperty("user.home");
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.userPath = this.userDir + this.fileSep + "." + this.appName;
        this.dataPath = this.userPath + this.fileSep + "data";
        this.configPath = this.userPath + this.fileSep + this.appName + ".ini";
        this.browseContentPath = this.userPath + this.fileSep + "browseContent.txt";
        this.initManager = new InitManager(this);
        this.initManager.readConfig();
        this.editColumns = this.sv_editColumns;
        this.autoRepeatCheckBox.setSelected(this.sv_autoRepeat);
        this.fullFrame = new FullScreenFrame(this);
        this.smallImage = new ImagePanel(this, "main");
        this.smallImage.setBorder(null);
        CommonCode.addComponent(this.smallImage, this.ImagePanel, 0, 0);
        this.helpPane = new MyHelpPane(this);
        CommonCode.addComponent(this.helpPane, this.helpTab);
        this.thumbnailGenerator = new ScaledImageGenerator(this);
        CommonCode.addComponent(this.thumbnailGenerator, this.setupPanel, 0, 0, 2, 1.0, 1.0);
        this.setupControlPanel = new SetupControlPanel(this);
        CommonCode.addComponent(this.setupControlPanel, this.setupPanel, 0, 1, 2, 1.0, 1.0);
        CommonCode.testMakeDirs(this.dataPath);
        this.createShowList(this.ShowListComboBox, this.dataPath);
        this.setScreenState(this.sv_screenState);
        this.editBase = new EditBase(this);
        CommonCode.addComponent(this.editBase, this.editTab);
        this.readShowFile(false);
        this.startStopAutoShow(false);
        if (this.sv_currentTab == 0) {
            this.requestFocusInWindow();
        }
        this.setupStateMonitor();
    }

    void setupStateMonitor() {
        this.outOfMemoryThread = new Thread(){

            @Override
            public void run() {
                MagicLantern.this.stateMonitor();
            }
        };
        this.outOfMemoryThread.start();
    }

    void stateMonitor() {
        while (true) {
            try {
                while (true) {
                    boolean bl;
                    Date date = new Date();
                    boolean bl2 = bl = this.outOfMemoryFlag != null && this.outOfMemoryFlag.getTime() < date.getTime() - 2000L;
                    if (bl) {
                        this.outOfMemoryFlag = null;
                        Runtime.getRuntime().gc();
                        this.showMemoryWarning();
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception exception) {
                System.out.println("Main:outOfMemoryMonitor(): " + exception);
                continue;
            }
            break;
        }
    }

    public BufferedImage readImage(File file) {
        if (!file.exists()) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            Runtime.getRuntime().gc();
            if (this.outOfMemoryFlag != null) {
                bufferedImage = ImageIO.read(file);
            } else {
                this.outOfMemoryFlag = new Date();
                bufferedImage = ImageIO.read(file);
                this.outOfMemoryFlag = null;
            }
        }
        catch (Exception exception) {
            System.out.println("main:readImage() : " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage readImage(String string) {
        return this.readImage(new File(string));
    }

    public void showMemoryWarning() {
        CommonCode.beep();
        String string = this.programName + " is very low on memory, a problem\n";
        string = string + "usually caused by large image files. To fix this,\n";
        string = string + "please read the help section on \"Memory Problems\".";
        JOptionPane.showMessageDialog(this, string, this.programName + ": Memory Problem", 2);
    }

    public void performSoundEffect(ShowDataItem showDataItem) {
        if (showDataItem == null || showDataItem.getSoundPath() == null) {
            this.mp3Player.close();
        } else {
            String string = showDataItem.getSoundPath();
            File file = new File(string);
            if (file.exists()) {
                this.mp3Player.play(string);
            }
        }
    }

    public void setStatus(String string, boolean bl, int n2) {
        if (this.getTab() == n2) {
            this.statusLabel.setText(string);
            if (bl) {
                CommonCode.beep();
            }
        }
    }

    String[] readFileList(String string) {
        File file = new File(string);
        MyFileNameFilter myFileNameFilter = new MyFileNameFilter(".*\\.txt$");
        String[] stringArray = file.list(myFileNameFilter);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].replaceFirst("(?i)(.*).txt", "$1");
            }
            Arrays.sort(stringArray, new StringComparatorNoCase());
        }
        return stringArray;
    }

    void fillComboBox(JComboBox jComboBox, String[] stringArray) {
        CommonCode.populateComboBox(jComboBox, stringArray, 0);
        jComboBox.insertItemAt(this.disabledTitle, 0);
    }

    public void buildShowList(JComboBox jComboBox, String string) {
        String[] stringArray = this.readFileList(string);
        this.fillComboBox(jComboBox, stringArray);
    }

    public void updateShowList() {
        String string = (String)this.ShowListComboBox.getSelectedItem();
        this.buildShowList(this.ShowListComboBox, this.dataPath);
        this.ShowListComboBox.setSelectedItem(string);
    }

    void createShowList(JComboBox jComboBox, String string) {
        this.buildShowList(jComboBox, string);
        this.sv_showIndex = CommonCode.min(this.sv_showIndex, jComboBox.getItemCount() - 1);
        this.sv_showIndex = CommonCode.max(this.sv_showIndex, 0);
        if (this.sv_showIndex < jComboBox.getItemCount()) {
            jComboBox.setSelectedIndex(this.sv_showIndex);
        }
    }

    void comboActionPerformed(ActionEvent actionEvent) {
        if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
            this.readShowFile(true);
        }
    }

    void readShowFile(boolean bl) {
        this.sv_showIndex = this.ShowListComboBox.getSelectedIndex();
        String string = (String)this.ShowListComboBox.getSelectedItem();
        String string2 = CommonCode.readTextFile(this.dataPath + this.fileSep + string + ".txt", this.lineSep);
        String[] stringArray = string2 == null || string2.length() == 0 ? new String[]{} : string2.split(this.lineSep);
        this.showList = new ShowList[]{new ShowList(stringArray, this), new ShowList(stringArray, this)};
        if (!bl) {
            this.showList[0].setIndex(this.sv_show0Index);
            this.showList[1].setIndex(this.sv_show1Index);
        }
        if (this.sv_currentTab == 0) {
            this.setStatus("Read " + stringArray.length + " images.", false, 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MagicLantern.this.showSlide(0, false);
                }
            });
        }
    }

    void swapShows() {
        ++this.sv_showListIndex;
        this.sv_showListIndex %= 2;
        this.showSlide(0, false);
    }

    boolean showSlide(int n2, boolean bl) {
        boolean bl2 = true;
        this.blankScreen = false;
        if (!this.editPreview) {
            this.sv_showListIndex = this.sv_showListIndex < 0 ? -this.sv_showListIndex : this.sv_showListIndex;
            this.sv_showListIndex %= 2;
            if (this.showList != null) {
                if (this.fullFrameMode) {
                    this.fullFrame.image().newImage(n2, this.showList[this.sv_showListIndex].getShowDataItem(n2), bl);
                } else {
                    this.smallImage.newImage(n2, this.showList[this.sv_showListIndex].getShowDataItem(n2), bl);
                }
            } else {
                CommonCode.beep();
            }
        }
        Runtime.getRuntime().gc();
        if (this.fullFrameMode) {
            this.fullFrame.requestFocusInWindow();
        } else {
            this.requestFocusInWindow();
        }
        return bl2;
    }

    void manageFullScreen(boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        try {
            if (bl) {
                this.fullFrameMode = true;
                graphicsDevice.setFullScreenWindow(this.fullFrame);
                this.smallImage.clearImage();
            } else {
                graphicsDevice.setFullScreenWindow(null);
                this.fullFrame.setVisible(false);
                this.fullFrame.image().clearImage();
                this.fullFrameMode = false;
            }
            Runtime.getRuntime().gc();
            if (this.showList != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MagicLantern.this.showSlide(0, true);
                    }
                });
            }
        }
        catch (Exception exception) {
            System.out.println("manageFullScreen: " + exception);
        }
    }

    void toggle_testPattern() {
        if (this.fullFrameMode) {
            this.fullFrame.image().toggleTestPattern();
        } else {
            this.smallImage.toggleTestPattern();
        }
    }

    void selectTab(int n2) {
        this.tabbedPane.setSelectedIndex(n2);
        this.sv_currentTab = n2;
        if (n2 == 0) {
            // empty if block
        }
    }

    public int getTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    void getCurrentTab() {
        if (this.priorTab == 1) {
            this.editBase.editPanel.saveFileOnExit();
        }
        this.sv_currentTab = this.tabbedPane.getSelectedIndex();
        if (this.sv_currentTab == 2) {
            this.setupControlPanel.updateMemStats();
        }
        int[] nArray = new int[]{3, 1, 2, 0};
        this.setScreenState(nArray[this.sv_currentTab]);
        if (this.sv_currentTab == 0) {
            // empty if block
        }
        this.priorTab = this.sv_currentTab;
    }

    void editPreview(ShowDataItem showDataItem) {
        this.setScreenState(3);
        this.editPreview = true;
        this.smallImage.newImage(0, showDataItem, true);
        String string = "<html>Previewing " + showDataItem.getName() + "<br/>Click image to return to editor.</html>";
        String string2 = "Previewing " + showDataItem.getName() + " -- click image to return to editor.";
        this.setStatus(string2, false, 0);
        this.smallImage.setToolTipText(string);
    }

    void handleMouseClick(MouseEvent mouseEvent) {
        if (this.editPreview) {
            this.smallImage.setToolTipText(null);
            this.setStatus("Status", false, 0);
            this.setScreenState(1);
            this.editPreview = false;
        }
    }

    void toggleBlankScreen() {
        this.blankScreen = !this.blankScreen;
        this.repaint();
    }

    void setScreenState(int n2) {
        this.sv_screenState = n2;
        switch (n2) {
            case 5: {
                this.manageFullScreen(true);
                this.selectTab(0);
                break;
            }
            case 4: {
                this.manageFullScreen(false);
                this.setExtendedState(this.getExtendedState() | 6);
                this.selectTab(0);
                break;
            }
            case 3: {
                this.manageFullScreen(false);
                this.setExtendedState(this.getExtendedState() & 0xFFFFFFF9);
                this.selectTab(0);
                break;
            }
            case 2: {
                this.autoShowOff();
                this.manageFullScreen(false);
                this.setExtendedState(this.getExtendedState() & 0xFFFFFFF9);
                this.selectTab(2);
                break;
            }
            case 1: {
                this.autoShowOff();
                this.manageFullScreen(false);
                this.setExtendedState(this.getExtendedState() & 0xFFFFFFF9);
                this.selectTab(1);
                break;
            }
            case 0: {
                this.autoShowOff();
                this.manageFullScreen(false);
                this.setExtendedState(this.getExtendedState() & 0xFFFFFFF9);
                this.selectTab(3);
                this.helpPane.setFocus();
            }
        }
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        keyEvent.consume();
        if (n2 == 46 || n2 == 66) {
            this.toggleBlankScreen();
        } else if (n2 == 123) {
            this.close();
        } else if (n2 == 119) {
            this.startStopAutoShow(true);
        } else if (n2 == 118) {
            this.setScreenState(2);
        } else if (n2 == 117) {
            this.toggle_testPattern();
        } else if (n2 == 116) {
            this.setScreenState(5);
        } else if (n2 == 115) {
            this.setScreenState(4);
        } else if (n2 == 114) {
            this.setScreenState(3);
        } else if (n2 == 113) {
            this.setScreenState(1);
        } else if (n2 == 112) {
            this.setScreenState(0);
        } else if (n2 == 39 || n2 == 40 || n2 == 32 || n2 == 34 || n2 == 78) {
            this.showSlide(1, false);
        } else if (n2 == 8 || n2 == 80 || n2 == 37 || n2 == 38 || n2 == 33) {
            this.showSlide(-1, false);
        } else if (n2 == 36) {
            this.showSlide(-1000000, false);
        } else if (n2 == 35) {
            this.showSlide(1000000, false);
        } else if (n2 == 27 || n2 == 10) {
            this.swapShows();
        }
    }

    void startStopAutoShow(boolean bl) {
        if (bl) {
            this.sv_autoShow = !this.sv_autoShow;
        }
        this.AutoShowButton.setSelected(this.sv_autoShow);
        if (this.sv_autoShow) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    MagicLantern.this.performAutoShow();
                }
            };
            thread.start();
        }
    }

    void autoShowOff() {
        this.AutoShowButton.setSelected(false);
        this.sv_autoShow = false;
    }

    void performAutoShow() {
        try {
            this.showSlide(-1000000, false);
            int n2 = this.sv_autoShowSlideDurationSeconds;
            while (this.sv_autoShow) {
                this.tabbedPane.setSelectedIndex(0);
                for (int i2 = 0; i2 < 10 && this.sv_autoShow; ++i2) {
                    Thread.sleep(n2 * 100);
                }
                if (!this.sv_autoShow) {
                    return;
                }
                if (this.lastAutoSlideFlag) {
                    if (this.sv_autoRepeat) {
                        this.showSlide(-1000000, false);
                        continue;
                    }
                    this.autoShowOff();
                    return;
                }
                this.showSlide(1, false);
            }
        }
        catch (Exception exception) {
            System.out.println("performAutoShow: " + exception);
        }
    }

    void updateThumbnailList(JList jList) {
        MyDefaultListModel myDefaultListModel = (MyDefaultListModel)jList.getModel();
        for (int i2 = 0; i2 < myDefaultListModel.size(); ++i2) {
            EditCellDatum editCellDatum = (EditCellDatum)myDefaultListModel.get(i2);
            editCellDatum.testLoadThumbnail();
            myDefaultListModel.contentsChanged(jList, i2, i2);
        }
    }

    void updateThumbnails() {
        this.updateThumbnailList(this.editBase.editPanel.getList());
        this.updateThumbnailList(this.editBase.browsePanel.getList());
    }

    void setAutoRepeat() {
        this.sv_autoRepeat = this.autoRepeatCheckBox.isSelected();
    }

    void close() {
        if (this.editBase.editPanel.saveFileOnExit()) {
            this.performSoundEffect(null);
            this.editBase.browsePanel.saveBrowseFile();
            if (this.showList != null) {
                this.sv_show0Index = this.showList[0].getIndex();
                this.sv_show1Index = this.showList[1].getIndex();
            }
            this.sv_autoRepeat = this.autoRepeatCheckBox.isSelected();
            this.sv_dividerLocation = this.editBase.getDividerLocation();
            this.sv_editColumns = this.editColumns;
            this.initManager.writeConfig();
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    private void initComponents() {
        this.StatusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.ImageTab = new JPanel();
        this.TopPanel = new JPanel();
        this.ShowListComboBox = new JComboBox();
        this.autoRepeatCheckBox = new JCheckBox();
        this.AutoShowButton = new JToggleButton();
        this.toBeginButton = new JButton();
        this.priorButton = new JButton();
        this.nextButton = new JButton();
        this.toEndButton = new JButton();
        this.swapButton = new JButton();
        this.blankButton = new JButton();
        this.quitButton = new JButton();
        this.ImagePanel = new JPanel();
        this.editTab = new JPanel();
        this.setupPanel = new JPanel();
        this.helpTab = new JPanel();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(200, 100));
        this.setName("MainFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MagicLantern.this.formWindowClosing(windowEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                MagicLantern.this.formKeyPressed(keyEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.StatusPanel.setFocusable(false);
        this.StatusPanel.setLayout(new GridBagLayout());
        this.statusLabel.setText("Status");
        this.statusLabel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.StatusPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.StatusPanel, gridBagConstraints);
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.setMinimumSize(new Dimension(100, 100));
        this.tabbedPane.setPreferredSize(new Dimension(600, 400));
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.tabbedPaneMouseClicked(mouseEvent);
            }
        });
        this.ImageTab.setBorder(null);
        this.ImageTab.setFocusable(false);
        this.ImageTab.setMinimumSize(new Dimension(200, 100));
        this.ImageTab.setPreferredSize(new Dimension(400, 300));
        this.ImageTab.setLayout(new GridBagLayout());
        this.TopPanel.setFocusable(false);
        this.ShowListComboBox.setToolTipText("Select a slide show");
        this.ShowListComboBox.setFocusable(false);
        this.ShowListComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MagicLantern.this.ShowListComboBoxActionPerformed(actionEvent);
            }
        });
        this.TopPanel.add(this.ShowListComboBox);
        this.autoRepeatCheckBox.setText("Repeat");
        this.autoRepeatCheckBox.setToolTipText("This option causes the auto show to repeat");
        this.autoRepeatCheckBox.setFocusable(false);
        this.autoRepeatCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.autoRepeatCheckBoxMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.autoRepeatCheckBox);
        this.AutoShowButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/network-offline.png")));
        this.AutoShowButton.setText("Auto");
        this.AutoShowButton.setToolTipText("Start/Stop Auto Show (keyboard F8)");
        this.AutoShowButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/network-offline.png")));
        this.AutoShowButton.setFocusable(false);
        this.AutoShowButton.setRolloverEnabled(false);
        this.AutoShowButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/network-receive.png")));
        this.AutoShowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.AutoShowButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.AutoShowButton);
        this.toBeginButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/go-first.png")));
        this.toBeginButton.setToolTipText("First Slide (keyboard Home)");
        this.toBeginButton.setFocusable(false);
        this.toBeginButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.toBeginButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.toBeginButton);
        this.priorButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/go-previous.png")));
        this.priorButton.setToolTipText("Prior Slide (keyboard PgUp or Left Arrow)");
        this.priorButton.setFocusable(false);
        this.priorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.priorButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.priorButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/go-next.png")));
        this.nextButton.setToolTipText("Next Slide (keyboard PgDn or Right Arrow)");
        this.nextButton.setFocusable(false);
        this.nextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.nextButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.nextButton);
        this.toEndButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/go-last.png")));
        this.toEndButton.setToolTipText("Last Slide (keyboard End)");
        this.toEndButton.setFocusable(false);
        this.toEndButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.toEndButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.toEndButton);
        this.swapButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/view-refresh.png")));
        this.swapButton.setToolTipText("Swap Image/Map (keyboard Escape or F5)");
        this.swapButton.setFocusable(false);
        this.swapButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.swapButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.swapButton);
        this.blankButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/system-lock-screen.png")));
        this.blankButton.setToolTipText("Blank Screen (keyboard \".\")");
        this.blankButton.setFocusable(false);
        this.blankButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.blankButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.blankButton);
        this.quitButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/application-exit.png")));
        this.quitButton.setToolTipText("Exit (F12)");
        this.quitButton.setFocusable(false);
        this.quitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.quitButtonMouseClicked(mouseEvent);
            }
        });
        this.TopPanel.add(this.quitButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.ImageTab.add((Component)this.TopPanel, gridBagConstraints);
        this.ImagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MagicLantern.this.ImagePanelMouseClicked(mouseEvent);
            }
        });
        this.ImagePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.ImageTab.add((Component)this.ImagePanel, gridBagConstraints);
        this.tabbedPane.addTab("Display", new ImageIcon(this.getClass().getResource("/magiclantern/icons/applications-multimedia.png")), this.ImageTab);
        this.editTab.setFocusable(false);
        this.editTab.setLayout(new GridBagLayout());
        this.tabbedPane.addTab("Create/Edit", new ImageIcon(this.getClass().getResource("/magiclantern/icons/applications-graphics.png")), this.editTab);
        this.setupPanel.setLayout(new GridBagLayout());
        this.tabbedPane.addTab("Configure", new ImageIcon(this.getClass().getResource("/magiclantern/icons/applications-accessories.png")), this.setupPanel);
        this.helpTab.setFocusable(false);
        this.helpTab.setLayout(new GridBagLayout());
        this.tabbedPane.addTab("Help", new ImageIcon(this.getClass().getResource("/magiclantern/icons/system-help.png")), this.helpTab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabbedPane, gridBagConstraints);
        this.pack();
    }

    private void priorButtonMouseClicked(MouseEvent mouseEvent) {
        this.showSlide(-1, false);
    }

    private void nextButtonMouseClicked(MouseEvent mouseEvent) {
        this.showSlide(1, false);
    }

    private void toBeginButtonMouseClicked(MouseEvent mouseEvent) {
        this.showSlide(-1000000, false);
    }

    private void toEndButtonMouseClicked(MouseEvent mouseEvent) {
        this.showSlide(1000000, false);
    }

    private void swapButtonMouseClicked(MouseEvent mouseEvent) {
        this.swapShows();
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.handleKeyPressed(keyEvent);
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.close();
    }

    private void quitButtonMouseClicked(MouseEvent mouseEvent) {
        this.close();
    }

    private void tabbedPaneMouseClicked(MouseEvent mouseEvent) {
        this.getCurrentTab();
    }

    private void blankButtonMouseClicked(MouseEvent mouseEvent) {
        this.toggleBlankScreen();
    }

    private void AutoShowButtonMouseClicked(MouseEvent mouseEvent) {
        this.startStopAutoShow(true);
    }

    private void autoRepeatCheckBoxMouseClicked(MouseEvent mouseEvent) {
        this.setAutoRepeat();
    }

    private void ImagePanelMouseClicked(MouseEvent mouseEvent) {
        this.handleMouseClick(mouseEvent);
    }

    private void ShowListComboBoxActionPerformed(ActionEvent actionEvent) {
        this.comboActionPerformed(actionEvent);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new MagicLantern().setVisible(true);
                }
                catch (Exception exception) {
                    System.out.println("Main (last resort exception trap): " + exception);
                }
            }
        });
    }
}

