class GraphinityHelp

   def initialize(app)
      @app = app
      @offset = 0
      @help_widget = @app.helpTextEdit()
      help_text = HelpText
      help_text.gsub!(/\[version\]/i,PROGRAM_VERSION)
      help_text.gsub!(/\[ini_file\]/i,@app.ini_file)
      @help_widget.buffer.text = help_text
   end

   def search(ss)
      buffer = @help_widget.buffer
      iter = buffer.get_iter_at_offset(@offset)
      result_iter = iter.forward_search(ss,Gtk::TextIter::SEARCH_TEXT_ONLY)
      if(!result_iter)
         @offset = 0
         iter.set_offset(0)
         buffer.place_cursor(iter)
         Gdk.beep
      else
         buffer.select_range(result_iter[0],result_iter[1])
         @offset = result_iter[1].offset
         iter = result_iter[0]
      end
      @help_widget.scroll_to_iter(iter,0.0,false,0,0)
   end
   HelpText = "\t\t\t\t*** Graphinity Help ***\n\nWelcome to Graphinity, a 2D and 3D graphing program written in Ruby.\n\nGraphinity [version] is Copyright 2008, P. Lutus.\n\nGraphinity [version] is released under the GPL:\n\nhttp://www.fsf.org/licensing/licenses/gpl.txt\n\nTo search this document, type search characters into the text entry control at the bottom of this window. Press Enter to move to the next match for a given search string.\n\nThis file contains only the kind of help one can put into a plain-text document. To acquire the most recent version of Graphinity and to read more complete documentation including graphic aids, visit the Graphinity Home Page at:\n\nhttp://www.arachnoid.com/ruby/graphinity\n\n* What is Graphinity?\n\nGraphinity [version] is a program that interactively creates graphs of mathematical equations. Graphinity can create two- and three-dimensional graphs and it supports anaglyphic renderings of three-dimensional graphs, that is, renderings that possess visual depth, for which the user will need a pair of anaglyphic glasses (with red and blue lenses).\n\nGraphinity is meant for students of mathematics, in particular of algebra and Calculus, and for anyone who needs to create and publish 2D and 3D graphs of various functions. Graphinity supports a wide variety of mathematical functions and interactively accepts and graphs the user's typed functions.\n\n* Requirements\n\nGraphinity is written in Ruby and GTK+, so both Ruby and the GTK+ libraries must be present on your system (they are both free). Here are links for both:\n\nRuby:\n\tLinux: ftp://ftp.ruby-lang.org/pub/ruby/ruby-1.8.5.tar.gz\n\tWindows: http://rubyinstaller.rubyforge.org/wiki/wiki.pl\nGTK+:\n\tLinux & Windows: http://www.gtk.org/download.html\n\nThe deep thinkers among my readers will wonder what is the point of my listing these essential prerequisites in the help file for a program that must be running for the help file to be read ... well, the plain-text help file is available in the download package, readable before installation.\n\n* First Steps\n\nWhen Graphinity is first run, this help text will be on display. Notice the tabs at the bottom of the Graphinity program window, marked “Control”, ”Display” and “Help”. The “Control” tab helps you set up your graph, the “Display” tab shows the graph in a larger format by hiding the controls, and the “Help” tab may or may not be able to help you sort this all out. Remember that there is much better documentation at the Graphinity Home Page (http://www.arachnoid.com/ruby/graphinity).\n\nGet into the habit of switching between the “Control” tab and the “Help” tab, so you can make changes to your graph while reading this text. For now, choose the “Control” tab, and select the “2D” tab within that tab.\n\nOn examining the Control display, you may notice there is no button marked “Plot”. To plot a function, simply type a function into the equation window and press “Enter”. Pressing “Enter” renders a graph of your function.\n\nMost of the other “Control” entries also cause the plot to be redrawn, so you can change the numerical range of a plot, or the number of steps, or the index properties, and the plot will change interactively. Feel free to experiment with these controls.\n\nWhen you first run Graphinity, the default 2D function is “E^-x^2”, which produces what is known as a Gaussian curve. The reader may wonder what “E” stands for -- it is the base of natural logarithms, 2.71828182845905 ..., and it is one of two predefined constants available in Graphinity, the other being PI. Both these constants need to be entered in uppercase.\n\nNow let's plot a new function. Place the mouse cursor in the entry window labeled “y(x) =” and type “sin(x)”. Press Enter. If this is your first function entry, the resulting graph line will descend below the bottom of the graphing window, so we might want to adjust the graph's scale. Move to the entry window for “Y Minimum”, enter “-1” and press Enter (or spin your mouse wheel over the entry). This adjusts for the fact that the function sin(x) produces a numerical range from -1 to +1.\n\nHere's another example, this one from spectrum analysis. Type the expression below into the window labeled “y(x) =” -- actually, you can save time by copying the expression from this page and pasting it into the equation window (to copy, use Ctrl+C, to paste, use Ctrl+V):\n\n0.upto(a) { |n| q=2*n+1; y += sin(x*q)/q }; y\n\nThis example relies on a knowledge of Ruby syntax -- it is actually a small Ruby function meant to compute a series, in this case the series that produces a square wave. The function is meant to show that any periodic waveform can be created out of individual sinusoidal components.\n\nTo play with this function, gradually change the value of \"Control A\" on the control panel from \"1\" to \"100\" (you can do this by spinning your mouse wheel over the control) to see how the result gradually approaches a square wave.\n\nNOTE: All Graphinity numerical inputs can be quickly and intuitively controlled using the mouse wheel -- just place the mouse cursor over the control and spin the mouse wheel to change the value.\n\nThis example is much like the one above but produces a triangle wave instead of a square wave:\n\n0.upto(a) { |n| q=2*n+1; y += cos(x*q)/(q*q) }; y\n\nHere is an example that uses the 3D mode (choose the \"3D\" tab at the left of the Graphinity display):\n\n0.upto(z) { |n| q=2*n+1; y += sin(x*q)/q }; y\n\nAgain, just copy the line above from this display into the 3D equation editor. For this example to work as intended in 3D, set the X range to (minimum,maximum) -PI,+PI, the Y range to -1,+1 and the z range to 0,12. An optional additional change would be to make the \"plot steps\" setting equal to 32 -- this requires more time to plot but produces a more detailed result. This example graphs in 3D the progression from a pure sinewave at the front to more of a square wave at the back.\n\nIn 3D mode, you may use the mouse to adjust the view -- drag the mouse on the image to rotate it vertically and horizontally, and use the mouse wheel to adjust the scale.\n\nThe point of these examples is to show that rather complex expressions that rely on Ruby syntax can be entered to produce more interesting results.\n\n* Scale Entries\n\nThe entry windows for X and Y, minimum and maximum, set the range for 2D plots. When you enter a function, the plotting range won't automatically change, in any case you may prefer settings that cannot be created automatically.\n\nThe X minimum and maximum values determine the input argument range for the function you enter as well as setting the display scale, and the Y minimum and maximum entries set the vertical scale of the resulting plot.\n\nThe scale entries can include things other than numbers. For example, because the argument for sin(x) is radians, you might want to scale the x range accordingly. For example, enter “-PI*2” for X minimum and “PI*2” for X maximum to change the graph's range. Experiment with the other settings to see how they affect the resulting graph.\n\nFinally, any of these entries may include control variables a, b and c, in which case changing the corresponding \"Control {a,b,c}\" value will control the value you have chosen. For example, you might want to interactively adjust the horizontal scale of a graph. To do this, set the X minimum and maximum values to \"-a\" and \"a\" respectively, then control the scale by spinning your mouse wheel over the \"Control A\" control.\n\n* Control and Interaction\n\nThere are two features that make Graphinity a bit unique in graphing programs. One is the presence of the three user-defined variables a, b and c, any of which can be used as part of an equation or as part of a scale or other entry. The other feature is that you can spin the mouse wheel over most numerical entries and the value will change. This greatly increases the speed and intuitiveness of program interaction compared to typing numbers.\n\n* Error recovery\n\nGraphinity saves a lot of information about itself and your choices in a user-level program data file. If you make a bad entry that you cannot easily undo, or you just want to start over with the default program values, do this:\n\n1. Exit the Graphinity program.\n2. Delete the program data file that is located on your system at [ini_file].\n3. Restart Graphinity.\n\n* Reading Specific Values from the Graph\n\nTo read particular numerical values from the graph, press the left mouse button and drag it to the point of interest. When you press the left mouse button, a crosshair will appear with x and y values for the point of interest.\n\nRoots of a Quadratic Equation\n\nLet's use the mouse function above to find the approximate roots of this quadratic equation:\n\n2*x^2 - 7*x + 5\n\n1. Type in the equation (or you can copy the text to the right of the equals sign from this help screen and paste it into the 2D equation window).\n\n2. Change the X and Y ranges to improve the accuracy of the estimate, and perhaps select the “Display” tab to increase the size of the graph.\n\n3. Drag the mouse cursor near the X values that correspond to Y = 0, that is, those points where the graph line crosses the Y = 0 axis. Play with the mouse positioning and notice how it provides specific numerical values for each position.\n\n4. By using this method, we can estimate the roots for this equation to be x = 1.0 and x = 2.5.\n\nThis way of finding roots is primitive and sketchy. It should only be used as a sanity check, or as a way to picture the behavior of a function in broad terms.\n\n* Three Dimensions\n\nGraphinity has a rather sophisticated 3D graph rendering engine that allows you to generate and view 3D graphs, rotate and scale them interactively, and even see them in true 3D using the anaglyphic method.\n\nTo start this exercise, click the tab marked “3D”, then place the mouse cursor in the entry window marked “y(x,z) =” and press Enter without changing the equation (which should by default be “E^-(x^2+z^2)” in case you need to restore it). You may want to set suitable X, and Y and Z graph scales -- if the values have been changed, set the X range to -3 and 3, set the Y range to -0.25 and 0.75, and set the Z range to -3 and 3.\n\nAt this point, you should see a 3D graph with a bump in the middle.\n\nA digression. 3D graphs require a fair amount of computer horsepower. If your computer is relatively fast, you may want to increase the number of 3D plotting steps from the default of 16 (the window marked “Plot steps”), which will improve the appearance and detail of the graph. But remember –- the time required to render a 3D graph is proportional to the square of the number of selected steps. A 3D \"plot steps\" entry of 32, or at most 64, is a practical limit on most personal computers.\n\n* Rotating 3D Graphs\n\nTo rotate the 3D graph, drag the mouse on the graph window. Drag vertically to flip the graph over, drag horizontally to spin it around. To zoom in and out, spin the mouse wheel. This is very intuitive and usually fast, but if a large number of 3D plotting steps has been chosen, there may be a significant delay between plots.\n\nRemember that 3D graph functions have two arguments, X and Z. X is the left-right dimension, and Z is the depth dimension (toward and away). The result of the function is plotted in the third dimension Y, up and down.\n\nExperiment with the 3D function input. Here is an interesting entry:\n\nE^-(x^2+z^2) * cos((x^2+z^2)*2)\n\nChoose X and Z ranges of -3,3 and a Y range of -0.25,0.75. This function creates a wavy pattern centered on X = 0, Z = 0, and it is difficult to view accurately without increasing the number of 3D plot steps.\n\nHere is another example 3D graph, a simple one that can be viewed with a small number of plotting steps:\n\nsin(x) + sin(z)\n\nTo better view this graph, change the X and Z ranges to -PI and PI, and set the Y range to -2 and 2. It is sort of a wavy plane, with a similar pattern in each dimension, which makes it hard to sort out on a 2D display surface. That means it's perfect for the next phase of these instructions.\n\n* Anaglyphic 3D\n\nGraphinity's 3D plots can be viewed in true 3D (e. g. with visual depth) if the user will acquire a set of 3D anaglyphic glasses, glasses with red and blue lenses. This is a terrific way to visualize mathematical functions, and I highly recommend it.\n\nTo use this feature, change the setting of the control labeled “Anaglyphic:”. The default setting is “None”, which means a 3D perspective projection, but no perceptible depth. While viewing a 3D function, change the anaglyphic setting to “White” and don your 3D glasses.\n\nIf you have a decent monitor that renders colors correctly, you will see that the plot now consists of a mixture of red and cyan lines on a white background, and the view through anaglyphic glasses will show depth. Remember about the anaglyphic plot that it is actually two complete plots, one red, one cyan, therefore it takes twice as much time to render as a normal 3D plot.\n\nOne way to deal with the slow anaglyphic rendering times is to use a smaller number of 3D plotting steps, in fact this is the most effective way to speed things up. Another way is to use the mouse controls to position and zoom the 3D graph to your taste before switching to the anaglyphic mode.\n\n* Exporting Graphs\n\nTo export a graph you want to use elsewhere, simply point at the graph and press the right mouse button. This will copy the displayed chart to the system clipboard. On most platforms, the clipboard contents can be pasted into existing word processing and graphic drawing/processing programs.\n\nI chose this export approach because there are any number of graphic formats, and if I had added a file save function I would have had to create a list of supported graphic formats. As it turns out, most platform clipboards know how to communicate with most receiving applications.\n\nRemember that the size of the clipboard graphic is the same as the displayed graphic, so to get a large copy, select the “Display” tab and perhaps even maximize the Graphinity program window before making the copy.\n\n* Exotic Functions\n\nGraphinity is written in Ruby, and the function entry windows are basically interpreted as Ruby code (with one change – Graphinity allows “^” to designate raising to a power, and Ruby doesn't). When you type in an ordinary, brief mathematical function, this background processing in Ruby isn't very important, but if you need to enter something exotic, it will help to know a little about Ruby.\n\nHere is an example that takes advantage of the Ruby engine running in the background. Enter this equation into the 3D function window:\n\n[ cos(x), cos(z) ].max\n\nTo display this function, select X and Z ranges of -PI*3, PI*3 and a Y range of -2,2. If you have the requisite computer horsepower, also set plot steps to 32. I call this plot the “waffle” for obvious reasons. Basically the above Ruby-specific entry creates an array consisting of two trig functions and then selects the maximum value at each plotted point.\n\nHere is another example, one that defines a value and then uses it:\n\ns = 1-(x^2+z^2); sqrt(s>=0?s:0)\n\nSelect X and Z ranges of -1,1 and a Y range of 0,1. The resulting graph looks like a dome.\n\nBecause any Ruby code can be entered into the equation windows, it should be possible to create some spectacular crashes, so I think it would be a good idea to moderate the wilder exploitations of this feature.\n\n* More about the control variables a, b, and c\n\nTo add to the level of interaction, begining with version 2.2 Graphinity includes adjustable values that can be included in an equation or a plot scaling entry. To use the control variable, simply add the variable a, b, or c (lower-case) to an equation or a scale entry, then adjust the corresponding control to see the results. The variable controls can be adjusted by putting the mouse cursor over the control and spinning the mouse wheel (by the way, this is true for most numerical inputs), or normal keyboard entries can be used.\n\n* State Recall\n\nBasically, Graphinity remembers everything between sessions. It creates and uses a program data file located on your computer at [ini_file] that contains your equation entries, the program window's size and position, colors, and everything else I could think of.\n\nAgain, if something goes wrong and Graphinity refuses to run, simply delete this program data file and run Graphinity again.\n\n* Available Math Functions\n\nHere is a list of the math functions Graphinity supports:\n\nacos,acosh,asin,asinh,atan,atan2,atanh,cos,cosh,erf,erfc,exp,hypot,log,log10,sin,sinh,sqrt,tan,tanh.\n\nSome of these functions have range limits. If their range is exceeded, an error dialog will appear explaining the problem. And remember, as shown in the examples above, you can create any unavailable functions.\n\n* Updates\n\nFor more information about Graphinity, including more colorful documentation and to check for the latest version, visit:\n\nhttp://www.arachnoid.com/ruby/graphinity\n\n"
end
